<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Webinar Details Form</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

    <style>
        body {

            font-family: 'Roboto', sans-serif;

            background-color: #f0f0f0;

        }



        .card {

            margin-bottom: 20px;

            border-radius: 8px;

            box-shadow: rgba(0, 0, 0, 0.05) 0px 0px 0px 1px;

        }



        .container {

            max-width: 700px;

            margin: 10px auto;

            padding: 20px;

            border-radius: 8px;

        }
    </style>

</head>



<body>
    <div class="container">
        <form action="<?php echo e(route('googleForm.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card">
                <div class="card-header" style="border-top: 10px solid rgb(103, 58, 183); background-color:white; text-align:center">
                    <h3>Registration for Physician Webinar</h3>
                </div>
<?php if(session('success')): ?>
   <div class="alert alert-success">
     <?php echo e(session('success')); ?>

   </div> 
<?php endif; ?>
                <div class="card-body">
                    <label for="name" class="form-label">Name *</label>
                    <input type="text" id="name" name="name" value="<?php echo e(old('name')); ?>" class="form-control" required>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <label for="email" class="form-label">Email*</label>
                    <input type="email" id="email" name="email" class="form-control" value="<?php echo e(old('email')); ?>" required>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <label for="phone" class="form-label">Phone</label>
<input type="tel" id="phone" name="phone" class="form-control">
                </div>
            </div>



            <div class="form-group local-forms">
        <label for="captcha ">Solve the following to submit the form:</label> <br>
        <div id="captchaQuestion"></div>
        <input type="number" id="captchaAnswer" name="captcha_answer" class="form-control" placeholder="Your answer">
        <div id="captchaError" style="color: red; display: none;">Please solve the CAPTCHA correctly to submit the form.</div>
    </div>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Generate random numbers and the correct answer
        const num1 = Math.floor(Math.random() * 10);
        const num2 = Math.floor(Math.random() * 10);
        const correctAnswer = num1 + num2;

        // Display the question
        document.getElementById('captchaQuestion').textContent = `${num1} + ${num2} = ?`;

        // Add event listener to the form submission
        document.getElementById('registrationForm').addEventListener('submit', function(event) {
            const userAnswer = parseInt(document.getElementById('captchaAnswer').value, 10);
            const captchaError = document.getElementById('captchaError');
            
            if (isNaN(userAnswer) || userAnswer !== correctAnswer) {
                event.preventDefault();
                captchaError.textContent = 'Incorrect CAPTCHA answer. Please try again.';
                captchaError.style.display = 'block';
            } else {
                captchaError.style.display = 'none';
            }
        });
    });
</script>

           
            
         

            <div>
                <input type="submit" value="Submit" class="btn btn-primary" style="background-color: rgb(103, 58, 183)"> &nbsp&nbsp
                <a href="https://myositisindia.org/" target="_blank">Go to Website</a>&nbsp&nbsp
                <a href="https://wa.me/919350646454" target="_blank">Need Help?</a>

                <a href="" style="float: right; color:rgb(103, 58, 183)">Clear Form</a> 
                <br>
                <div class="text-center">
                    <span style="font-size: 10px;">This form was created inside of Myositis India Pvt. Ltd
                        Report Abuse</span><br>
                    <h3>Myositis India.</h3>
                </div>
            </div>
        </form>
    </div>
</body>
</html><?php /**PATH /home2/madalozy/myositisindia.org/resources/views/googleform.blade.php ENDPATH**/ ?>