<?php $__env->startSection('content'); ?>

<style>
    /* Container and Header Styles */
    .team-container {
        padding: 20px;
    }
    .team-header {
        text-align: center;
        margin-bottom: 30px;
        font-size: 28px;
        font-weight: bold;
        color: #0056b3; /* Matches your blue tone */
        text-transform: uppercase;
    }

    /* Card Styles */
    .team-card {
        background-color: #ffffff;
        border: 2px solid #0056b3; /* Blue border to match your website */
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }
    .team-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 8px rgba(0, 0, 0, 0.2);
    }

    /* Role Styles */
    .team-role {
        font-size: 20px;
        font-weight: bold;
        margin-bottom: 10px;
        color: #0056b3; /* Matches your website theme */
        text-transform: capitalize;
    }

    /* Member List Styles */
    .team-members {
        list-style-type: none;
        padding-left: 0;
        margin: 0;
    }
    .team-members li {
        font-size: 16px;
        margin-bottom: 5px;
        line-height: 1.6;
        color: #333; /* Neutral text color */
    }
    .nested-role {
        font-weight: bold;
        margin-top: 10px;
        color: #0056b3; /* Highlighted blue for subroles */
    }
    .nested-members {
        list-style-type: circle;
        margin-left: 20px;
        color: #444; /* Slightly darker gray for nested items */
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .team-card {
            margin-bottom: 15px;
        }
        .team-role {
            font-size: 18px;
        }
        .team-members li {
            font-size: 14px;
        }
    }
</style>

<div class="container team-container">
    <h2 class="team-header">Meet Our Team</h2>
    <div class="row">
        <?php
            $team = [
                'MAB Liaison' => ['Anushka Ma’am'],
                'Director, Patient Services' => ['Shreya Sridhar', 'Rishabh', 'Rishi'],
                'Director, Content Creation' => [
                    'Rutvij Tope',
                    'Flyers' => ['Ishita', 'Dr. Ujjwal Madan'],
                    'Reels' => ['Parth', 'Rutvij', 'Vanshaj', 'Swaraj', 'Dinakar', 'Rishabh', 'Saloni'],
                    'Video Editing' => ['Rimzim', 'Sunil (patient volunteer)', 'Shrut']
                ],
                'Director, Social Media' => [
                    'Gokulkrishna Nambiar',
                    'Instagram' => ['Vanshaj'],
                    'Facebook' => ['Rishi'],
                    'LinkedIn, Twitter' => ['Srijan'],
                    'YouTube' => ['Swaraj'],
                    'Patient WhatsApp Group' => ['Aniket'],
                    'Doctor WhatsApp Group' => ['Prithvi'],
                    'Broadcast Lists' => ['Dinakar']
                ],
                'Director, Webinars and Events' => [
                    'Rutvik Savaliya',
                    'Shreya Patil', 'Kshitij', 'Shrut', 'Twisha'
                ],
                'Director, Academics and Research' => [
                    'Vanshaj Sharma',
                    'Harsshika', 'Devanshi', 'Janhabi', 'Aniket'
                ],
                'Head of Communications' => ['Dollma Rana'],
                'Director IT' => ['Sartaj Akhtar', 'Prajot Taide', 'Kush Aggarwal']
            ];
        ?>

        <?php $__currentLoopData = $team; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role => $members): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6">
                <div class="team-card">
                    <h4 class="team-role"><?php echo e($role); ?></h4>
                    <ul class="team-members">
                        <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(is_array($member)): ?>
                                <li class="nested-role">
                                    <?php echo e($key); ?>

                                    <ul class="nested-members">
                                        <?php $__currentLoopData = $member; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subMember): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($subMember); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                            <?php else: ?>
                                <li><?php echo e($member); ?></li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/myositisindia.org/resources/views/team/team1.blade.php ENDPATH**/ ?>