<!DOCTYPE html>
<html lang="en">



<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <title>Myositis - Patient Registration</title>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('backend/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/plugins/feather/feather.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/plugins/fontawesome/css/fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/plugins/fontawesome/css/all.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('backend/assets/css/style.css')); ?>">
    <style>
        img {
  max-width: 100%;
  max-height: 500px;
  height: auto;
}

    </style>
     
</head>

<body>

    <div class="main-wrapper login-body">
        <div class="container-fluid px-0">
            <div class="row">
                <div class="col-lg-6 login-wrap">
                    <div class="login-sec">
                        <div class="log-img">
                            <div class="md-lg-12 sm-12">
                                <img class="img-fluid" src="<?php echo e(asset('backend/assets/img/login-02.png')); ?>" alt="Logo" style="margin-top:40px;">

                            </div>
                        </div>
                    </div>
                </div>


                <div class="col-lg-6 login-wrap-bg">
                    <div class="login-wrapper">
                        <div class="loginbox">
                            <div class="login-right">
                                <div class="login-right-wrap">
                                    <div class="md-lg-12 sm-12">
                                      <a href="<?php echo e(route('home')); ?>">  <img src="<?php echo e(asset('asset/img/lo.jpeg')); ?>" alt="your image description" class="responsive-img"></a> <br><br>
                                    </div>
                                    <h4 style="text-align:center">Welcome to Patient Registration Page</h4>
                                    <p style="text-align:center; font-size:13px">We are excited to have you join our community. </p>
                                    <p style="text-align:center;color:#2E37A4;"> If you've already registered, just log in <br> <a href="<?php echo e(route('user.login')); ?>" class="btn btn-success">Login here</a>&nbsp&nbsp<a href="<?php echo e(route('home')); ?>" class="btn btn-success">Go to Home Page</a></p>
                                   
                                    <hr>
                                    <?php if(Session::has('success')): ?>
                                    <div class="alert alert-success">
                                        <?php echo e(Session::get('success')); ?>


                                    </div>
                                        
                                    <?php endif; ?>
                                    <form action="<?php echo e(route('user.register')); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <select name="role" id="" required onchange="userRole(this)"
                                                class="form-control">
                                                <option value="" selected>
                                                    Are you a Patient or a Family Member (relative)? </option>
                                                <option value="2" >Patient</option>
                                                <option value="2">Family Member</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="fname" placeholder="First Name" required
                                                class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="lname" placeholder="Last Name" required
                                                class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="phone" placeholder="Mobile"
                                                class="form-control" required>

                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="email" placeholder="Email"
                                                class="form-control" required>

                                        </div>
                                        <div class="fomr-group">
                                            <input type="password" name="password" class="form-control"
                                                placeholder="Password" required>

                                        </div> <br>
                                        <div class="form-group">
                                            <input type="password" name="cpassword" class="form-control"
                                                placeholder="Confirm password" required>
                                        </div>

                                        <div class="form-group mb-3">
                                            <select id="country-dd" class="form-control" name="country" required>
                                                <option value="" >Select Country</option>
                                                <?php $__currentLoopData = $counteries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($data->id); ?>"><?php echo e($data->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group mb-3">
                                            <select id="state-dd" class="form-control" name="state" required></select>
                                        </div>
                                        <div class="form-group mb-3">
                                            <select id="city-dd" class="form-control" name="city" required></select>
                                        </div>
                                        <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
                                        <script type="text/javascript">
                                            $(document).ready(function() {
                                                $('#country-dd').change(function(event) {
                                                    var idCountry = this.value;
                                                    $('#state-dd').html('');

                                                    $.ajax({
                                                        url: "/api/fetch-state",
                                                        type: 'POST',
                                                        dataType: 'json',
                                                        data: {
                                                            country_id: idCountry,
                                                            _token: "<?php echo e(csrf_token()); ?>"
                                                        },
                                                        success: function(response) {
                                                            $('#state-dd').html('<option value="">Select State</option>');
                                                            $.each(response.states, function(index, val) {
                                                                $('#state-dd').append('<option value="' + val.id + '"> ' +
                                                                    val.name + ' </option>')
                                                            });
                                                            $('#city-dd').html('<option value="">Select City</option>');
                                                        }
                                                    })
                                                });
                                                $('#state-dd').change(function(event) {
                                                    var idState = this.value;
                                                    $('#city-dd').html('');
                                                    $.ajax({
                                                        url: "/api/fetch-cities",
                                                        type: 'POST',
                                                        dataType: 'json',
                                                        data: {
                                                            state_id: idState,
                                                            _token: "<?php echo e(csrf_token()); ?>"
                                                        },
                                                        success: function(response) {
                                                            $('#city-dd').html('<option value="">Select State</option>');
                                                            $.each(response.cities, function(index, val) {
                                                                $('#city-dd').append('<option value="' + val.id + '"> ' +
                                                                    val.name + ' </option>')
                                                            });
                                                        }
                                                    })
                                                });
                                            });
                                        </script>
                                         <div id="adan">
                                            <div class="form-group">
                                                <select name="disease_id"  class="form-control" required>
                                                    <option value="">Type of Myositis</option>
                                                    <?php $__currentLoopData = $disease; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                                                </select>
                                            </div>
                                            
                                           
                                       
                                             
                                            <div class="form-group">
                                                <select name="gender" id="" class="form-control">
                                                    <option value="">Gender</option>
                                                    <option id="male" name="gender" value="male" required>Male</option>
                                                    <option id="female" name="gender" value="female" required>Female</option>
                                                    <option  id="other" name="gender" value="other" required>Other</option>
                                                </select>
                                            </div>
                                    
                                            <div class="form-group">
                                                <input type="text" class="form-control" name="dob" placeholder="Age" required>
                                            </div>
                                            <div class="form-group">
                                                <input type="text" name="doctorName" placeholder="Your Doctor Name" class="form-control" required>
    
                                               </div>

                                        <textarea name="message" cols="30" rows="3" placeholder=" Tell us about yourself" class="form-control" required></textarea>

                                        <input type="checkbox" id="terms" value="1" name="terms" required style="margin-top: 10px;">
                                        <label for="terms" style="font-size: 15px;">I accept the <a
                                                href="<?php echo e(route('termcondition')); ?>">terms and
                                                conditions</a> of
                                            Myositis India</label> <br> <br>
                                        <div class="form-group login-btn">
                                            <button class="btn btn-primary btn-block" type="submit">Submit</button>
                                        </div>
                                        
                                    </form>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <script src="<?php echo e(asset('backend/assets/js/jquery-3.6.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/feather.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/app.js')); ?>"></script>
</body>

 
</html>
<?php /**PATH D:\myositis india\21june backup\well-known (6)\resources\views/auth/register.blade.php ENDPATH**/ ?>