
<?php $__env->startSection('content'); ?>
<div class="container">
    <section id="content">	
			
        <!-- Page Heading -->
        <section class="section page-heading animate-onscroll">
            
            <h1>About Myositis</h1>
            <p class="breadcrumb"><a href="main-v1.html">Home</a> / About Myositis</p>
            
        </section>
        <!-- Page Heading -->
        

        
        <!-- Section -->
        <section class="section full-width-bg gray-bg">
            
            <div class="row">
            
            
                <div class="col-lg-9 col-md-9 col-sm-8">
                    
                    <h3 class="animate-onscroll no-margin-top">About Myositis</h3>
                    
                    <img class="align-left animate-onscroll" src="<?php echo e(asset('asset/img/p1.jpeg')); ?>" alt="" width="359" height="250">
                    
                    <p class="animate-onscroll">Myositis simply means inflammation of muscle. ‘Myo’ refers to Muscle and ‘itis’ refers to inflammation.</p>
                    
                    <p class="animate-onscroll" style="text-align: justify">The term "myositis" encompasses a broad range of conditions characterized by swelling and inflammation of the muscles. It can be due to many causes such as autoimmune conditions, infections, medication-related muscle injury, hereditary diseases, imbalanced electrolytes, or thyroid issues.</p>
                    
                    <p class="animate-onscroll" style="text-align: justify">The term "myositis" most commonly refers to a chronic disease characterized by muscle inflammation, which often presents alongside other symptoms. This type of myositis is commonly referred to as idiopathic inflammatory myopathy (IIM). Myositis is highly diverse and has been classified into various forms, such as dermatomyositis (DM), polymyositis (PM), necrotizing myopathy (NM), sporadic inclusion body myositis (sIBM), and juvenile forms of myositis (JM).</p>
                    
                    <img class="animate-onscroll" src="img/about3.jpg" alt="">
                    
                    <p class="animate-onscroll" style="text-align: justify">Inflammatory myopathies are uncommon autoimmune diseases, in which the body's immune system mistakenly attacks healthy tissue instead of defending against foreign invaders like infections or viruses. The exact cause of myositis is still unknown, but some researchers believe that certain individuals may have a genetic vulnerability to developing autoimmune diseases when triggered by environmental factors, such as infection, viruses, toxins, or sunlight. However, the specific triggers remain elusive. </p>
                    <h3 class="animate-onscroll no-margin-top">What are symptoms of Myositis?</h3>
                    
                    <p class="animate-onscroll" style="text-align: justify">Symptoms of weakness and, in some cases, muscle pain often develop gradually. Prior to a proper diagnosis, patients may struggle with everyday tasks such as rising from a low chair, climbing stairs, combing their hair, dressing, or holding objects. They may experience falls or difficulty in lifting their arms, among other symptoms. On the other hand, myositis may also present itself suddenly, especially in children. As the disease advances, some patients may experience difficulty swallowing (dysphagia) or breathing, which can indicate the presence of interstitial lung disease (ILD) caused by inflammation in the lung tissue. Muscle pain and weakness are common symptoms. Additionally, it is not uncommon for patients with myositis to have additional autoimmune diseases.</p>
                    <h3 class="animate-onscroll no-margin-top">How is Myositis diagnosed?</h3>
                    
                    <p class="animate-onscroll" style="text-align: justify">Myositis is challenging to diagnose due to limited knowledge of the disease among physicians and its rarity, making it difficult to gather enough patients for effective research on treatments. Despite these challenges, myositis is a severe illness that requires prompt and aggressive management, as it can lead to significant disability or death without proper treatment. Though symptoms can be managed and periods of remission can occur, there is no permanent cure for myositis and it is a long term or lifelong condition.</p>
                    <h3 class="animate-onscroll no-margin-top">Types of Myositis </h3>
                    <div class="col-lg-12">
                        <div class="col-lg-4 md-col-4 sm-col-4">
                            <h3>Dermatomyositis</h3>
                            <p style="text-align: justify">Dermatomyositis (DM) is a form of myositis that can affect individuals of any age and gender, but is more commonly seen in women. It is characterized by muscle weakness, which develops gradually over time and is typically seen in the limbs closest to the core, such as the shoulders and hips</p>
                             <a href=""><button>Lear More</button></a>


                        </div>
                        <div class="col-lg-4 md-col-4 sm-col-4">
                            <h3>Polymyositis</h3>
                            <p style="text-align: justify">Polymyositis (PM) is more commonly found in adult women than men. It typically causes muscle weakness which develops gradually over time, starting with the muscles near the trunk of the body such as the neck, hips, back, and shoulders. Some people with PM may experience muscle pain,  </p>
                           <a href=""> <button >Lean More</button></a>
                        </div>
                        <div class="col-lg-4 md-col-4 sm-col-4">
                            <h3>Necrotizing Myopathy</h3>
                            <p style="text-align: justify">Necrotizing myopathy, also known as necrotizing autoimmune myopathy (NAM) or immune-mediated necrotizing myopathy (IMNM), was once believed to be a rare form of muscle disease, but has recently been recognized as a prevalent form of muscle inflammation.   </p>
                            <a href=""><button>Learn More</button></a>
                        </div>
                        
                    </div>
                    <div class="col-lg-12">
                        <div class="col-lg-4 md-col-4 sm-col-4">
                            <h3>Juvenile Myositis   </h3>
                            <p style="text-align: justify">Juvenile Myositis (JM), a condition that affects children under the age of 18, is characterized by muscle weakness and skin rashes. The most common form of JM is Juvenile Dermatomyositis (JDM), which is not linked to cancer like adult forms of the disease. Juvenile Polymyositis   </p>
                            <a href=""><button>Learn More</button></a>
                        </div>
                        <div class="col-lg-4 md-col-4 sm-col-4">
                            <h3>Inclusion Body Myositis: </h3>
                            <p style="text-align: justify">Sporadic inclusion body myositis (sIBM) is a type of acquired myopathy that mostly affects individuals over the age of 50 and is more common in men than women. It is distinct from other forms of myositis in terms of   </p>
                            <a href=""><button>Learn More</button></a>
                        </div>
                         
                    </div> <br><br>
                    <h3 class="animate-onscroll no-margin-top">Fatigue in Myositis:</h3>
                    
                    <img class="align-left animate-onscroll" src="<?php echo e(asset('asset/img/fatigue.png')); ?>" alt="" width="359" height="250">
                    
                    <p class="animate-onscroll" style="text-align: justify">Myositis patients often experience fatigue due to the weakening of their muscles by the disease. When a muscle or muscle group becomes weak, the other muscles have to work harder to compensate, leading to fatigue. It is understandable to want to avoid movement due to muscle pain and fatigue, but doing so only exacerbates the problem. Muscles that are not regularly used will become weaker and can even waste away if left unused for too long. Exercise is crucial in maintaining muscle strength and preventing atrophy, as well as helping the body compensate for weakness by strengthening surrounding muscles. Stretching, both actively by the patient and passively through assistance from a care partner, is also important for maintaining mobility, particularly for patients with fixed weakness.</p>
                    <h3 class="animate-onscroll no-margin-top">Diet for Myositis Patients:</h3>
                    <p class="animate-onscroll" style="text-align: justify">The Importance of Diet and Nutrition in Myositis A well-balanced diet can greatly improve overall health, and some individuals with myositis have reported significant improvements in their symptoms through special diets such as paleo or vegan or vegetarian diet. However, the anti-inflammatory or Mediterranean diet is a simple and easily adaptable eating plan that can benefit everyone, especially those with autoimmune diseases. To follow this diet, it is recommended to: 
                        <ul>
                            <li>Avoid processed and fast foods, which often contain high fructose corn syrup, artificial ingredients, preservatives, and pesticides. Instead, opt for a variety of fresh fruits and vegetables and unrefined foods. </li>
                            <li>Limit your intake of wheat flour and sugar, specifically in bread, pasta, and packaged snacks. Switch to whole grain alternatives like brown rice and bulgur wheat. • Reduce the amount of saturated fat consumed by eating less animal fats and products made with palm kernel oil. </li>
                            <li>Use extra-virgin olive oil and expeller-pressed canola, sunflower, and safflower oil. Avoid partially hydrogenated oils. </li>
                            <li>Incorporate avocados and nuts, especially walnuts, cashews, almonds, and nut butters made from these nuts. </li>
                            <li>Consume more vegetable protein, particularly from beans and soy, and choose fish, cheese, and yogurt more often than animal proteins. </li>
                            <li>Steer clear of soda, including diet soda, and choose tea over coffee</li>
                            <li>If you drink alcohol, red wine is a better option. </li>
                            <li>Enjoy chocolate in moderation with a minimum cocoa content of 70%.</li>
                            <li>Prednisone increases hunger, leading to weight gain. To avoid this, one should limit high-calorie foods and eat several small meals throughout the day to regulate blood sugar levels. Regular physical activity is also recommended. </li>
                            <li>To lower the chances of high blood pressure and fluid retention, it's advisable to limit salt intake to less than 1,500mg daily. This can be achieved by eating fresh, unprocessed foods and avoiding the addition of salt during cooking. </li>
                            <li> If you are taking medication for high blood pressure, you may need to increase your intake of potassium-rich foods, such as bananas, apricots, cantaloupe, baked potatoes, and tomatoes. </li>
                            <li>Corticosteroids can also irritate the stomach, so it's important to take them with food and not on an empty stomach. </li>
                            <li>• Corticosteroid use also increases the risk of diabetes. To keep blood sugar levels in the normal range, one should avoid foods high in simple carbohydrates like sugar and maintain a carbohydrate intake between 45 and 60 mg per day.   </li>
                        </ul>
                    </p> <br><br>
                    <h3 class="animate-onscroll no-margin-top">Supplementary medication – Vitamins and Minerals for Myositis:</h3>
                    
                    <img class="align-left animate-onscroll" src="<?php echo e(asset('asset/img/blog/b3.png')); ?>" alt="" width="359" height="250">
                    
                    <p class="animate-onscroll">Supplementation Recommendations for Myositis Patients When it comes to dietary supplements, there are many options and intended uses to consider. However, for those with myositis, the following are some specific recommendations: 
                        <ul>
                            <li>Calcium is an important factor for those taking prednisone, as it can lead to bone loss and osteoporosis. To address this, consume calcium-rich foods such as dairy products, leafy greens, almonds, and broccoli, and consider taking calcium supplements</li>
                            <li>Vitamin D is produced in the skin from exposure to sunlight and plays a crucial role in calcium absorption and other bodily processes. Since most individuals do not get enough sun exposure, taking Vitamin D supplements is advisable. </li>
                            <li> Folic acid is a B-vitamin found in leafy greens, spinach, broccoli, and other sources. However, for those taking the anti-inflammatory medication methotrexate, it can interfere with the body's use of folic acid. Therefore, supplementing with folic acid is recommended to meet their needs. </li>
                            <li>Maintaining a balanced ratio of omega-3 (anti-inflammatory) and omega-6 (pro-inflammatory) fatty acids is important for overall health. However, the typical American diet tends to have a higher ratio of omega-6, which is found in vegetable oils, meat, eggs, etc. To counterbalance this, consume more foods rich in omega-3 fatty acids such as salmon, mackerel, sardines, leafy greens, flaxseed, canola oil, walnuts, and enriched eggs, and consider taking omega-3 supplements.</li>
                        </ul>
                    </p>
                    <h3 class="animate-onscroll no-margin-top">Sun Protection:</h3>
                    
                    
                    
                    <p class="animate-onscroll">Everyone, particularly those with lighter skin, should take precautions to protect their skin from excessive sun exposure to reduce the risk of skin cancer. Myositis patients, however, need to be extra cautious in avoiding sun exposure to their skin, as even brief periods of sun exposure can cause symptoms to worsen in about 20% of myositis patients. To minimize the risk of sun damage, myositis members recommend the following strict sun safety measures:  
                        <ul>
                            <li>Use sunblock with a minimum SPF of 50, even indoors and all year round, and make sure to apply it to all exposed skin. </li>
                            <li>Reapply sunblock 30 minutes prior to going outside and reapply often. </li>
                            <li>Don't forget to apply sunblock to your hands, and reapply after washing them. </li>
                            <li>Wear a hat, sunglasses, gloves, long-sleeved shirt and pants/skirt when outside, including while driving</li>
                            <li>Wear double layers of clothing or clothing specifically designed for sun protection. Be mindful of unexpected places where UV rays can reflect, such as moonlight, metallic rocks, water, cars, and windows and other glass surfaces. </li>
                            <li>Keep in mind that UV rays can penetrate through glass, so shades, heavy curtains or special window coatings are recommended for your home and office. </li>
                            <li>Use LED lightbulbs instead of regular lightbulbs, as they emit fewer UV rays. </li>
                            <li> Try to avoid going outside between 11am and 4pm. </li>
                            <li> Use laundry detergent that includes a UV protection chemical.</li>
                        </ul>
                    </p>


                    
                    
                     
                    
                </div>
                
                
                
                <!-- Sidebar -->
                <?php echo $__env->make('pages.myositis.sidebarforpages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- /Sidebar -->
                
                
            
            </div>
            
        </section>
        <!-- /Section -->
    
    </section>


</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\myositis india\myositisindia\resources\views/pages/myositis/aboutmyositis.blade.php ENDPATH**/ ?>