<?php $__env->startSection('title', 'Medical Advisory Board | Myositis India – Expert Guidance & Leadership'); ?>
<?php $__env->startSection('description', 'Meet the experts on our Medical Advisory Board who guide and support Myositis India.'); ?>
<?php $__env->startSection('canonical', 'https://www.myositisindia.org/mab/show'); ?>
<?php $__env->startSection('content'); ?>

<div class="container">

    <section id="content">

        <!-- Page Heading -->
        <section class="section page-heading animate-onscroll">
            <h3>Medical Advisory Board</h3>
            <p class="breadcrumb"><a href="main-v1.html">Home</a> / Medical Advisory Board</p>
        </section>
        <!-- Page Heading -->

        <!-- Section -->
        <section class="section full-width-bg gray-bg">
            <div class="row">
                <!-- Session Tabs -->
                <div class="col-lg-12 mb-4">
                    <!-- Buttons for each session -->
                    <button class="btn btn-primary" id="btn2024">2024-2025</button>
                    <button class="btn btn-primary" id="btn2023">2023-2024</button>
                </div>

                <br><br>

                <!-- Ambassadors List by Session -->
                <div class="col-lg-9 col-md-9 col-sm-12">
                    <div class="row">
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session => $ambassadors): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="session-group" id="session-<?php echo e($session); ?>" style="display: <?php echo e($session == '2024-2025' ? 'block' : 'none'); ?>;">
                                <?php $__currentLoopData = $ambassadors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ambassador): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-sm-12 col-md-4 mb-4">
                                        <div class="card" style="width:250px; height:450px;">
                                            <img src="<?php echo e(asset(Storage::url($ambassador->image))); ?>" alt="" class="card-img-top" width="250" height="250px">
                                            <div class="card-body">
                                                <h4 class="card-title">
                                                    <span style="color: #274472; font-size:15px;">
                                                        <b><?php echo e($ambassador->name); ?></b> <br>Location: <?php echo e($ambassador->city); ?>

                                                    </span>
                                                </h4>
                                                <p class="card-text" style="text-align: justify; width:200px;"><?php echo e(Str::limit($ambassador->message, 100)); ?></p>
                                                <a href="<?php echo e(route('mab_member.show', $ambassador->id)); ?>" class="btn btn-primary">Know More</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Sidebar -->
                <?php echo $__env->make('myositis.sidebarforpages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </section>

    </section>
</div>

<?php $__env->stopSection(); ?>

<!-- JavaScript to Handle Session Toggle -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to show the selected session
        function showSession(session) {
            // Hide all session groups
            document.querySelectorAll('.session-group').forEach(function(group) {
                group.style.display = 'none';
            });

            // Show the selected session group
            const selectedSession = document.getElementById('session-' + session);
            if (selectedSession) {
                selectedSession.style.display = 'block';
            }
        }

        // Add event listeners to buttons
        document.getElementById('btn2024').addEventListener('click', function() {
            showSession('2024-2025');
        });

        document.getElementById('btn2023').addEventListener('click', function() {
            showSession('2023-2024');
        });
    });
</script>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/myositisindia.org/resources/views/medicaladvisoryboard/mab.blade.php ENDPATH**/ ?>