
<?php $__env->startSection('content'); ?>
<div class="container">
    <section id="content">	
			
        <!-- Page Heading -->
        <section class="section page-heading animate-onscroll">
            
            <h1>  Inclusion Body Myositis</h1>
            <p class="breadcrumb"><a href="main-v1.html">Home</a> / Inclusion Body Myositis</p>
            
        </section>
        <!-- Page Heading -->
        

        
        <!-- Section -->
        <section class="section full-width-bg gray-bg">
            
            <div class="row">
            
            
                <div class="col-lg-9 col-md-9 col-sm-8">
                    
                    <h3 class="animate-onscroll no-margin-top">About Inclusion Body Myositis</h3>
                    
                    <img class="align-left animate-onscroll" src="<?php echo e(asset('asset/img/myositis-types/ibm.png')); ?>" alt="" width="359" height="250">
                    
                    <p class="animate-onscroll"> <i>Sporadic inclusion body myositis (sIBM) is a type of acquired myopathy that mostly affects individuals over the age of 50 and is more common in men than women.</i>  </p>
                    
                    <p class="animate-onscroll" style="text-align: justify">. It is distinct from other forms of myositis in terms of symptoms, treatment, and patient demographics.
                        The symptoms of sIBM progress slowly, with weakness gradually increasing over time, sometimes over years. This slow progression and the age of typical patients often lead to the symptoms being mistaken for old age.  </p>
                    
                    <p class="animate-onscroll" style="text-align: justify">sIBM frequently causes asymmetrical weakness, particularly in the upper legs, wrist flexors, fingers, forearms, and feet, and about two-thirds of patients may experience difficulty swallowing. Creatine kinase levels can be normal or elevated, but never more than ten times the normal levels.
                        There is a debate among experts on whether sIBM is an inflammatory or degenerative disease. Some evidence points to an autoimmune process due to the presence of inflammatory cells and autoantibodies, while other evidence suggests a degenerative process within the muscles. However, most experts agree that a comprehensive approach that addresses both inflammation and muscle degeneration is necessary for optimal treatment and a cure.
                        </p>
                        <p class="animate-onscroll" style="text-align: justify">It's important to note that sIBM should not be confused with hereditary inclusion body myopathy (hIBM), as the latter is caused by a gene defect and affects a younger population. The average age of onset for hIBM is between the teenage years and mid-twenties, and it typically causes distal weakness in the extremities, with CK levels ranging from normal to slightly elevated.</p>
                    <h3 class="animate-onscroll no-margin-top">What are symptoms of Inclusion Body Myositis?</h3>
                    
                    <p class="animate-onscroll" style="text-align: justify">Polymyositis is a rare autoimmune disease that affects the skeletal muscles, causing inflammation and progressive muscle weakness. The symptoms of polymyositis can vary widely, but some common ones include:
                    <ul>
                        <li>Muscle weakness: This is the most common symptom of dermatomyositis and can affect any muscle group, but usually affects the proximal muscles (hips, shoulders, neck).</li>
                        <li>Skin rash: A characteristic rash on the face, chest, back, hands, and/or elbows is a common symptom of dermatomyositis. The rash often appears before the muscle weakness.</li>
                        <li>Difficulty swallowing: This can occur if the muscles responsible for swallowing are affected.</li>
                        <li>Fatigue: Many people with dermatomyositis experience extreme fatigue and weakness, even with minimal activity.</li>
                        <li>Joint pain: Joint pain and stiffness may be present, especially in the morning.</li>
                        <li>Shortness of breath: This can occur if the muscles responsible for breathing are affected.

                        </li>
                        <li>Raynaud's phenomenon: This is a condition in which the fingers or toes turn white or blue in response to cold or stress.</li>
                    </ul>
                    </p>
         
                </div>
                
                
                
                <!-- Sidebar -->
                <?php echo $__env->make('myositis.sidebarforpages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- /Sidebar -->
                
                
            
            </div>
            
        </section>
        <!-- /Section -->
    
    </section>


</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/myositisindia.org/resources/views/myositis/ibm.blade.php ENDPATH**/ ?>