
<?php $__env->startSection('content'); ?>
    <div class="container">
        <section id="content">


            <!-- Page Heading -->
            <section class="section page-heading animate-onscroll">

                <h1>Get Involved</h1>
                <p class="breadcrumb"><a href="main-v1.html">Home</a> / Get Involved</p>

            </section>
            <!-- Page Heading -->




            <!-- Section -->
            <section class="section full-width-bg gray-bg">

                <div class="row">

                    <div class="col-lg-9 col-md-9 col-sm-8">

                        <div class="animate-onscroll">
                            <h3 class="no-margin-top">Get Involved</h3>
                            <p>Welcome to our Get Involved website page! We are thrilled that you are considering giving
                                your time and skills to make a positive difference in our community.

                                As a volunteer, you will have the opportunity to contribute to a cause that you are
                                passionate about, meet like-minded individuals, and develop new skills. Whether you have
                                just a few hours to spare or can commit to an ongoing project, your contributions will make
                                a significant impact. </p>
                            <p>We have a wide range of volunteer opportunities available, including working with children,
                                supporting local environmental initiatives, and helping those in need. No matter what your
                                interests or skills are, there is sure to be a project or program that is right for you.</p>
                            <p>We also understand that your time is valuable, which is why we are committed to providing a
                                fulfilling and enjoyable volunteer experience. Our team is dedicated to ensuring that our
                                volunteers receive the training and support they need to succeed.</p>
                        </div>
                       
                        <div >
                            <?php if(Session::has('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(Session::get('success')); ?>

    
                            </div>
                            <?php endif; ?>
                            <form action="<?php echo e(route('user.register')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <input type="hidden"  name="role" value="3">
                                <div class="form-group">
                                    <input type="text" name="fname" placeholder="First Name" required
                                        class="form-control">
                                </div>
                                <div class="form-group">
                                    <input type="text" name="lname" placeholder="Last Name" required
                                        class="form-control">
                                </div>
                                <div class="form-group">
                                    <input type="text" name="phone" placeholder="Mobile"
                                        class="form-control" required>
    
                                </div>
                                <div class="form-group">
                                    <input type="text" name="email" placeholder="Email"
                                        class="form-control" required>
    
                                </div>
                                <div class="fomr-group">
                                    <input type="password" name="password" class="form-control"
                                        placeholder="Password" required>
    
                                </div>  <br>
                                <div class="form-group">
                                    <input type="password" name="cpassword" class="form-control"
                                        placeholder="Confirm password" required>
                                </div><br>
    
                                <div class="form-group mb-3">
                                    <select id="country-dd" class="form-control" name="country" required>
                                        <option value="" >Select Country</option>
                                        <?php $__currentLoopData = $counteries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->id); ?>"><?php echo e($data->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group mb-3">
                                    <select id="state-dd" class="form-control" name="state" required >
                                        <option value="">Select State</option>
                                    </select>
                                </div>
                                <div class="form-group mb-3">
                                    <select id="city-dd" class="form-control" name="city" required>
                                        <option value="">Select City</option>
                                    </select>
                                </div>
                                <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
                                <script type="text/javascript">
                                    $(document).ready(function() {
                                        $('#country-dd').change(function(event) {
                                            var idCountry = this.value;
                                            $('#state-dd').html('');
    
                                            $.ajax({
                                                url: "/api/fetch-state",
                                                type: 'POST',
                                                dataType: 'json',
                                                data: {
                                                    country_id: idCountry,
                                                    _token: "<?php echo e(csrf_token()); ?>"
                                                },
                                                success: function(response) {
                                                    $('#state-dd').html('<option value="">Select State</option>');
                                                    $.each(response.states, function(index, val) {
                                                        $('#state-dd').append('<option value="' + val.id + '"> ' +
                                                            val.name + ' </option>')
                                                    });
                                                    $('#city-dd').html('<option value="">Select City</option>');
                                                }
                                            })
                                        });
                                        $('#state-dd').change(function(event) {
                                            var idState = this.value;
                                            $('#city-dd').html('');
                                            $.ajax({
                                                url: "/api/fetch-cities",
                                                type: 'POST',
                                                dataType: 'json',
                                                data: {
                                                    state_id: idState,
                                                    _token: "<?php echo e(csrf_token()); ?>"
                                                },
                                                success: function(response) {
                                                    $('#city-dd').html('<option value="">Select State</option>');
                                                    $.each(response.cities, function(index, val) {
                                                        $('#city-dd').append('<option value="' + val.id + '"> ' +
                                                            val.name + ' </option>')
                                                    });
                                                }
                                            })
                                        });
                                    });
                                </script>
                                 <div id="adan">
                                    
                                    <div class="form-group">
                                        <select name="gender" id="" class="form-control">
                                            <option value="">Gender</option>
                                            <option id="male" name="gender" value="male" required>Male</option>
                                            <option id="female" name="gender" value="female" required>Female</option>
                                            <option  id="other" name="gender" value="other" required>Other</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="dob" placeholder="Age" required>
                                    </div>
                                <textarea name="message" cols="30" rows="3" placeholder="Tell us about yourself" class="form-control" required></textarea>
    
                                <input type="checkbox" id="terms" value="1" name="terms" required style="margin-top: 10px;">
                                <label for="terms" style="font-size: 15px;">I accept the <a
                                        href="<?php echo e(route('termcondition')); ?>">terms and
                                        conditions</a> of
                                    Myositis India</label> <br> <br>
                                <div class="form-group login-btn">
                                    <button class="btn btn-primary btn-block" type="submit">Submit</button>
                                </div>
                            </form>
    
    
                        </div>
                       
                    </div>
                    </div>



                    <!-- Sidebar -->

                    <?php echo $__env->make('myositis.sidebarforpages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <!-- /Sidebar -->



                </div>

            </section>
            <!-- /Section -->

        </section>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\myositis india\12june backup\well-known (5)\resources\views/volunteer.blade.php ENDPATH**/ ?>