<?php $__env->startSection('content'); ?>
<div id="donation-wrapper">
    <div id="donation-card">
        <!-- Card Header -->
        <div id="donation-header" class="text-white text-center">
            <h3 class="donate-title">🌟 Donate 🌟</h3>
        </div>

        <!-- Content Section (Side-by-Side on Desktop, Stacked on Mobile) -->
        <div id="donation-content">
            <!-- Bank Details Section -->
            <div id="bank-details">
                <h4 class="donation-text-dark font-weight-bold mb-3">💳 Bank Transfer Details</h4>
                <div class="bank-box">
                    <div class="bank-item">
                        <span class="bank-icon">🏦</span> 
                        <strong>Bank Name</strong>
                        <span class="bank-value">IndusInd Bank Limited</span>
                    </div>
                    <div class="bank-item">
                        <span class="bank-icon">📌</span> 
                        <strong>Account No</strong>
                        <span class="bank-value">201024503355</span>
                    </div>
                    <div class="bank-item">
                        <span class="bank-icon">🔢</span> 
                        <strong>IFSC Code</strong>
                        <span class="bank-value">INDB0000012</span>
                    </div>
                    <div class="bank-item">
                        <span class="bank-icon">📍</span> 
                        <strong>Branch</strong>
                        <span class="bank-value">M-56 Greater Kailash II, (Main Market) New Delhi - 110048</span>
                    </div>
                </div>
            </div>

            <!-- QR Code Section -->
            <div id="qr-section">
                <h5 class="donation-text-primary font-weight-bold mb-3">📲 Scan & Pay via UPI</h5>
                <div class="qr-box">
                    <img src="<?php echo e(asset('asset/img/qrcode.jpg')); ?>" alt="QR Code" id="qr-code">
                    <p class="donation-text-muted">Scan the QR code using any UPI app to donate instantly.</p>
                </div>
            </div>
        </div>

        <!-- Card Footer -->
        <div id="donation-footer">
            <p class="donation-text-muted">🙏 Thank you for your support! Every contribution makes a difference. 🙌</p>
        </div>
    </div>
</div>

<style>
    /* Ensure the entire donation card is perfectly centered */
    #donation-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
        padding: 20px;
    }

    #donation-card {
        background: #ffffff;
        max-width: 800px;
        width: 100%;
        border-radius: 10px;
        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
        padding: 20px;
        text-align: center;
    }

    /* Premium Gradient Header */
    #donation-header {
        background: linear-gradient(135deg, #2c72b5, #1a3e72);
        padding: 15px;
        border-radius: 10px 10px 0 0;
    }

    /* Premium "Donate" Title Styling */
    .donate-title {
        font-size: 28px;
        font-weight: bold;
        text-transform: uppercase;
        background: linear-gradient(90deg, #C0C0C0, #E5E4E2);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        text-shadow: 3px 3px 8px rgba(229, 228, 226, 0.6);
        letter-spacing: 2px;
        font-family: 'Poppins', sans-serif;
    }

    /* Side-by-Side on Desktop, Stacked on Mobile */
    #donation-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 20px;
        flex-wrap: wrap;
        gap: 20px;
    }

    #bank-details, #qr-section {
        flex: 1;
        padding: 15px;
        min-width: 300px;
    }

    /* Enhanced Bank Details Box */
    .bank-box {
        background: linear-gradient(to right, #e3f2fd, #bbdefb);
        border-left: 5px solid #2c72b5;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 4px 4px 15px rgba(0, 0, 0, 0.1);
        text-align: left;
    }

    .bank-item {
        display: flex;
        flex-direction: column; /* Moves text below label */
        align-items: flex-start;
        font-size: 16px;
        padding: 10px;
        background: rgba(255, 255, 255, 0.6);
        border-radius: 8px;
        margin-bottom: 8px;
        box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.05);
    }

    .bank-icon {
        font-size: 20px;
        margin-bottom: 5px;
    }

    .bank-value {
        font-size: 18px;
        font-weight: bold;
        color: #1a3e72;
        margin-top: 3px;
        display: block;
    }

    /* QR Code Section */
    .qr-box {
        background: #fff;
        border: 2px dashed #2c72b5;
        padding: 15px;
        border-radius: 10px;
        display: inline-block;
        width: 100%;
    }

    #qr-code {
        max-width: 200px;
        border-radius: 10px;
        box-shadow: 3px 3px 10px rgba(0, 0, 0, 0.2);
    }

    /* Footer */
    #donation-footer {
        padding: 15px;
        background: #f1f1f1;
        border-radius: 0 0 10px 10px;
    }

    /* Mobile Optimizations */
    @media (max-width: 768px) {
        #donation-content {
            flex-direction: column;
            gap: 10px;
        }
        
        #bank-details, #qr-section {
            width: 100%;
            min-width: unset;
            text-align: center;
        }

        .bank-box {
            padding: 15px;
        }

        #qr-code {
            max-width: 150px;
        }

        #donation-wrapper {
            min-height: auto;
            padding: 40px 20px;
        }

        .bank-item {
            align-items: center;
            text-align: center;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/myositisindia.org/resources/views/showqrcode.blade.php ENDPATH**/ ?>