
<?php $__env->startSection('title', 'Case Presentation Winners | Myositis India – Medical Excellence & Recognition'); ?>
<?php $__env->startSection('description', 'Celebrate the winners of our case presentation competition highlighting clinical excellence.'); ?>
<?php $__env->startSection('canonical', 'https://www.myositisindia.org/case-presentation-winner'); ?>
<?php $__env->startSection('content'); ?>
<style>
    .winner-card {
        background-color: #fff;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        margin-bottom: 20px;
        transition: transform 0.3s ease;
        position: relative; /* To position the badge absolutely */
    }

    .winner-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
    }

    .winner-image img {
        width: 220px;
        height: 220px;
        object-fit: cover;
        display: block;
        margin: 0 auto;
    }

    .winner-info {
        padding: 15px;
    }

    .winner-info h4 {
        margin-bottom: 10px;
        font-size: 1.25em;
        font-weight: bold;
        color: #333;
    }

    .winner-info p {
        margin: 0;
        font-size: 1em;
        color: #777;
    }

    /* Badge styling */
    .badge {
        position: absolute;
        top: 10px;
        left: 10px;
        background-color: #d9534f; /* Bootstrap danger color */
        color: #fff;
        padding: 5px 10px;
        font-size: 0.85em;
        font-weight: bold;
        border-radius: 5px;
        text-transform: uppercase;
    }

    .badge.runner-up {
        background-color: #f0ad4e; /* Bootstrap warning color */
    }

    @media (max-width: 767px) {
        .winner-card {
            margin-bottom: 20px;
        }
    }
</style>

<div class="container">
    <section id="content">
        <!-- Page Heading -->
        <section class="section page-heading animate-onscroll">
            <h3>Case Presentations Winner</h3>
            <p class="breadcrumb"><a href="<?php echo e(route('home')); ?>">Home</a> / Case Presentation Competition 2023 Winners Highlights</p>
        </section>
        <!-- /Page Heading -->

        <!-- Section -->
        <section class="section full-width-bg gray-bg">
            <div class="row">
                <div class="col-lg-9 col-md-9 col-sm-12">
                    <div class="row">
                       <h2>Case Presentation Competition 2025 Winners</h2>
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div class="winner-card">
                                <div class="badge">Winner</div>
                                <div class="winner-image">
                                    <!-- Replace with actual image if available -->
                                    <img src="<?php echo e(asset('asset/img/Pridhivi.jpeg')); ?>" alt="Dr. Pridhivi Bhargavi" class="img-responsive">
                                </div>
                                <div class="winner-info">
                                    <h4>Dr. Pridhivi Bhargavi</h4>
                                    <p>Senior Resident</p>
                                    <p>Department of Medicine</p>
                                    <p>AIIMS New Delhi</p>
                                </div>
                            </div>
                        </div>
                        <!-- 1st Runner Up -->
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div class="winner-card">
                                <div class="badge runner-up">1st Runner Up</div>
                                <div class="winner-image">
                                    <!-- Replace with actual image if available -->
                                    <img src="<?php echo e(asset('asset/img/Nidhi.jpg')); ?>" alt="Dr. Nidhi Goel" class="img-responsive">
                                </div>
                                <div class="winner-info">
                                    <h4>Dr. Nidhi Goel</h4>
                                    <p>1st year SR</p>
                                    <p>Army Hospital (Research and Referral)</p>
                                    <p>New Delhi</p>
                                </div>
                            </div>
                        </div>
                        <!-- 2nd Runner Up -->
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div class="winner-card">
                                <div class="badge runner-up">2nd Runner Up</div>
                                <div class="winner-image">
                                    <!-- Replace with actual image if available -->
                                    <img src="<?php echo e(asset('asset/img/Israrul.jpeg')); ?>" alt="Dr. Israrul Haque" class="img-responsive">
                                </div>
                                <div class="winner-info">
                                    <h4>Dr. Israrul Haque</h4>
                                    <p>Ex Senior Resident Rheumatology, AIIMS New Delhi</p>
                                    <p>DM resident Clinical Immunology and Rheumatology</p>
                                    <p>IPGMER, Kolkata</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- 2023 Winners Section moved below -->
                    <div class="row">
                       <h2>Case Presentation Competition 2023 Winners</h2>
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div class="winner-card">
                                <div class="badge">Winner</div>
                                <div class="winner-image">
                                    <img src="<?php echo e(asset('asset/img/casePresentation/2023winners/1.jpg')); ?>" alt="Dr. Alekhya Amudalapalli" class="img-responsive">
                                </div>
                                <div class="winner-info">
                                    <h4>Dr. Alekhya Amudalapalli</h4>
                                    <p>DM Resident</p>
                                    <p>Department of Clinical Immunology and Rheumatology</p>
                                    <p>Institute of Medical Sciences and SUM Hospital, Bhubaneswar</p>
                                </div>
                            </div>
                        </div>

                        <!-- Runner Up 1 -->
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div class="winner-card">
                                <div class="badge runner-up">Runner Up</div>
                                <div class="winner-image">
                                    <img src="<?php echo e(asset('asset/img/casePresentation/2023winners/2.jpg')); ?>" alt="Dr. Hiren Kalyani" class="img-responsive">
                                </div>
                                <div class="winner-info">
                                    <h4>Dr. Hiren Kalyani</h4>
                                    <p>DrNB Trainee (2022-2025)</p>
                                    <p>Department of Rheumatology</p>
                                    <p>Max Super Speciality Hospital, Saket, New Delhi</p>
                                </div>
                            </div>
                        </div>
                        <!-- Runner Up 2 -->
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div class="winner-card">
                                <div class="badge runner-up">Runner Up</div>
                                <div class="winner-image">
                                    <img src="<?php echo e(asset('asset/img/casePresentation/2023winners/3.jpeg')); ?>" alt="Dr. Harsh Jain" class="img-responsive">
                                </div>
                                <div class="winner-info">
                                    <h4>Dr. Harsh Jain</h4>
                                    <p>3rd year resident</p>
                                    <p>Department of Rheumatology</p>
                                    <p>Army Hospital, Delhi</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Sidebar -->
                <?php echo $__env->make('myositis.sidebarforpages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- /Sidebar -->
            </div>
        </section>
        
        <!-- /Section -->
    </section>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/myositisindia.org/resources/views/casePresentation/casePresentationWinner.blade.php ENDPATH**/ ?>